varying vec3	w0,
				w1,
				w2;
//attribute vec3 	normal;
attribute vec4	binormal; 
varying vec3	viewDir;
uniform mat4	WTM;
uniform vec3	campos;

varying vec2 	texcoord;
uniform vec2	tscale0;

//uniform vec2	tofs;		// cambiare in uniform
		
void main()
{  
	vec4 normal4   	= vec4( gl_Normal.xyz, 0.0 );
	vec4 binormal4  = vec4( binormal.xyz, 0.0 );
	vec4 tangent4   = vec4(cross(binormal4.xyz,normal4.xyz),0.0);
	binormal4.xyz*=binormal.w;

	vec4 	outTangent,
			outNormal,
			outBinormal;
			
	outNormal=normalize(WTM*normal4);
	outTangent=normalize(WTM*tangent4);
	outBinormal=normalize(WTM*binormal4);

	w0=vec3(outTangent.x,outBinormal.x,outNormal.x);
	w1=vec3(outTangent.y,outBinormal.y,outNormal.y);
	w2=vec3(outTangent.z,outBinormal.z,outNormal.z);

	// transform to world space
	vec4 vpos=WTM*gl_Vertex;

	// compute view direction
	viewDir=campos-vpos.xyz;

	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0.st*tscale0;// + tofs;
}